return Def.ActorFrame {
	Def.Quad{
		Name="TopMask";
		--InitCommand=cmd(x,8;y,-68;zoomto,296,90;valign,1;clearzbuffer,true;zwrite,true;blend,Blend.NoEffect;);
		InitCommand=cmd(x,0;y,-69;zoomto,280,60;valign,1;clearzbuffer,true;zwrite,true;blend,Blend.NoEffect;);
	};
	Def.Quad{
		Name="BottomMask";
		InitCommand=cmd(x,0;y,130;zoomto,280,60;valign,0;clearzbuffer,false;zwrite,true;blend,Blend.NoEffect;);
	};
	Def.CourseContentsList {
		--CourseContents Main
		MaxSongs = 100;
		NumItemsToDraw = 5;
		InitCommand=cmd(playcommand,"Refresh");
		RefreshCommand=function(self)
			self:finishtweening();
			self:clearzbuffer(true);
			self:zwrite(true);
			self:zbuffer(true);
			self:ztest(true);
			self:z(0);
			self:setsecondsperitem(0.0001);
			self:SetDestinationItem(0);
			self:SetCurrentAndDestinationItem(2);
			self:SetFromGameState();
			self:setsize(260,200);
			self:PositionItems();
			self:SetTransformFromHeight(26);
			self:SetSecondsPauseBetweenItems(0);
			self:SetLoop(false);
			local coursestages = GAMESTATE:GetCurrentCourse():GetEstimatedNumStages()
			if coursestages < 6 or coursestages == nil then
				self:stoptweening();
			else
				self:queuecommand("ScrollUp");
				self:scrollthroughallitems();
			end;
		end;
		ScrollDownCommand = function(self)
			self:finishtweening();
			self:clearzbuffer(true);
			self:zwrite(true);
			self:zbuffer(true);
			self:ztest(true);
			self:z(0);
			self:setsecondsperitem(1);
			self:SetDestinationItem( (self:GetNumChildren()-2)-1 );
			local fTime = self:GetSecondsToDestination();
			self:sleep(fTime + 1);
			self:queuecommand("ScrollUp");
		end;
		ScrollUpCommand = function(self)
			self:finishtweening();
			self:setsecondsperitem(0.0001);
			self:SetDestinationItem(0);
			self:SetCurrentAndDestinationItem(2);
			self:sleep(1);
			self:queuecommand("ScrollDown");
		end;
		CurrentCourseChangedMessageCommand=function(self)
			local course = GAMESTATE:GetCurrentCourse();
			self:visible( course and true or false );
			self:playcommand("Refresh");
		end;
		CurrentTrailP1ChangedMessageCommand=function(self)
			self:playcommand("Refresh");
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			self:playcommand("Refresh");
		end;

		--Parts
		Display = Def.ActorFrame { 
			InitCommand=cmd(setsize,270,26);

			LoadActor(THEME:GetPathG("CourseEntryDisplay","bar")) .. {
				SetSongCommand=function(self, params)
				end;
			};

			Def.TextBanner {
				InitCommand=cmd(x,-101;y,1;Load,"CourseTextBanner";SetFromString,"", "", "", "", "", "");
				SetSongCommand=function(self, params)
					if params.Song then
						self:SetFromSong( params.Song );
						self:diffuse( SONGMAN:GetSongColor(params.Song) );
					else
						self:SetFromString( "??????????", "??????????", "", "", "", "" );
						self:diffuse( color("#FFFFFF") );
					end
					(cmd(zoom,0.75))(self);
				end;
			};

			LoadFont("CourseEntryDisplay","number") .. {
				InitCommand=cmd(x,-109;y,-3;shadowlength,0;zoom,0.75;maxwidth,30;);
				SetSongCommand=function(self, params)
					local numStages = GAMESTATE:GetCurrentCourse():GetEstimatedNumStages()
					if params.Number <= numStages then
						self:settext(string.format("%i", params.Number)); 
					end;
				end;
			};
			-- replacement for foot
			LoadActor( THEME:GetPathG("DifficultyDisplay","Bar") )..{
				InitCommand=cmd(x,91;y,-2;zoom,0.75;animate,false);
				SetSongCommand=function(self, params)
					local difficultyToFrame = {
						Difficulty_Beginner = 0,
						Difficulty_Easy = 1,
						Difficulty_Medium = 2,
						Difficulty_Hard = 3,
						Difficulty_Challenge = 4,
						Difficulty_Edit = 5,
					};
					if params.Difficulty then
						self:setstate(difficultyToFrame[params.Difficulty]);
					end;
				end;
			};
			LoadFont("CourseEntryDisplay","difficulty") .. {
				Text="0";
				InitCommand=cmd(x,124;y,-2;shadowlength,0;zoom,1;horizalign,right;skewx,-0.125;maxwidth,26);
				SetSongCommand=function(self, params)
					if params.PlayerNumber ~= GAMESTATE:GetMasterPlayerNumber() then return end
						self:settext( params.Meter );
					if params.Difficulty then
						self:diffuse( CustomDifficultyToColor(params.Difficulty) );
					end;
				end;
			};

		};
	};
};